function [fusion_times, states] = directMethod_SingleSyt_DNmutant3(VS0, par, Ca, evalVes,RRPmax, steadyIO, TrackstatesIO)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%This function computes vesicle fusion times following the gillespie
%algorithm. It allows for variation in number of syts

%Inputs
%VS0 - steady state matrix
%par - model parameters (see list below)
%Ca - evaluated Calcium concentration
%evalVes - number of vesicle fusions to evaluate
%RRPmax - number of vesicles
%trackstates - whether or not to evaluate the state of the system

%Outputs
%Fusion_times - Fusion time points of SVs
%states - Number of crosslinks formed per vesicle 

% Initialize
MAX_OUTPUT_LENGTH = 1e7;
%samplingrate = 22e3;
n=size(VS0,1); %no Syts
ves=size(VS0,2); %no ves.
T = 0;

%numEval = 50;

VSout = VS0;

k_onCa = par(1);
KD = par(2);
k_onPIP2 = par(3);
PIP2 = par(4);
c = par(5);
l = par(6);
f = par(7);
nsyt = par(8);
maxcross = par(9);
cacoop = par(10);
maxCa = par(11);
Kd_pip = par(12);

CaIP=Ca;

alpha = CaIP^cacoop * k_onCa;
beta = KD*k_onCa;
gamma = PIP2 * k_onPIP2;
delta = Kd_pip*k_onPIP2; %%% ops: KD for PIP2 different than for Ca2+!!!

transitions = [1, 10, -1, -10];
fusion_times = NaN(RRPmax, 1);
%fusion_times = NaN(evalVes, 1);
rxn_count = 1; %Reaction counter
fused_ves = 0;%fusion_count = 0;


%% MAIN LOOP

VSin=VSout;
PIPbound = repmat(sum(VSin==11 | VSin==1,1), nsyt, 1);

if TrackstatesIO
    time_count = 1;
    states= cell(ves*1e5,1);
   states{1}(1) =0;
    states{3} = sum(VSin==11);
else
    states = [];
end


%Compute propensity matrix
a_1 = ((VSin==0).*((max(maxcross-PIPbound,0)).*gamma) + (VSin==1).*(delta) + (VSin==10).*(beta+(max(maxcross-PIPbound,0)).*gamma) + (VSin==11).*(delta*c+beta*c)...
+((VSin==0)+(VSin ==1)).*alpha + (VSin  ==1).*(delta));
a_2 = l.*f.^sum((VSin==11),1);
%a_2 = l.*f.^(VSin==11);
a = vertcat(a_1,a_2);
a0 = sum(sum(a,1));

while ((rxn_count < 1e4 && steadyIO == 1)||(fused_ves < evalVes && steadyIO ==0))
   % Calculate reaction propensities
    VSin=VSout;
    
    if a0 > 0 %Make sure there are still releaseable vesicles    
        r = rand(1,4);
        tau = (1/a0)*log(1/r(1));
        ves_ind  = find((cumsum(sum(a,1)) >= r(2)*a0),1,'first'); % Determine vesicle number

         %%%%%%Carry out reaction
        %determine reaction of vesicle
        syt_ind = find((cumsum(a(:,ves_ind)) >= r(3)*sum(a(:,ves_ind))),1,'first'); % Determine reaction number;
        if syt_ind == n+1 %Fusion reaction
            fused_ves = fused_ves+1;
            fusion_times(fused_ves)=T;
            VSout=VSin;
            VSout(:,ves_ind)=-1;
            a(:, ves_ind) =0;   %vesicle does not participate in fusion any more
            a0=sum(sum(a));
           
            if TrackstatesIO
                states{2}(ves_ind) = T;
            end
            
        else %Binding unbinding reaction
                
                a_react = [(1-mod(VSin(syt_ind,ves_ind),10))*gamma*max(maxcross - PIPbound(syt_ind, ves_ind),0), ...
                    (1-floor(VSin(syt_ind,ves_ind)/10))*alpha, mod(VSin(syt_ind,ves_ind),10)*delta*c^floor(VSin(syt_ind,ves_ind)/10), ...
                    floor(VSin(syt_ind,ves_ind)/10)*beta*c^mod(VSin(syt_ind,ves_ind),10)];
           
                reaction_type = find((cumsum(a_react) >= r(4)*sum(a_react)),1,'first'); % Determine reaction number;
            
                VSout=VSin;
            
                VSout(syt_ind,ves_ind) = VSin(syt_ind,ves_ind)+transitions(reaction_type); % carry out reaction
                

            %update a-Matrix
            
            PIPbound(:, ves_ind) = repmat(sum(VSout(:, ves_ind)==11 | VSout(:, ves_ind)==1,1), nsyt, 1);
            
               
               a(1:n, ves_ind) =((VSout(:, ves_ind)==0).*(gamma*max(maxcross- PIPbound(:, ves_ind), 0)) ...
               + (VSout(:, ves_ind) ==1).*(delta)  ...
               + (VSout(:, ves_ind) ==10).*(beta+gamma*max(maxcross - PIPbound(:,ves_ind), 0)) ... 
               + (VSout(:, ves_ind) ==11).*(delta*c+beta*c)...
               + ((VSout(:, ves_ind) == 0) + (VSout(:, ves_ind) ==1)).*alpha ...
               );
%           
               a(n+1,ves_ind)=l*f^sum((VSout(:,ves_ind)==11),1);
           
            a0=sum(sum(a));
            
            
            
        end
        T   = T  + tau;
        rxn_count = rxn_count + 1;
        
        if TrackstatesIO
            if syt_ind <nsyt
            if VSout(syt_ind, ves_ind) == 11 || VSin(syt_ind, ves_ind) == 11 %only updates states when a crosslink is formed or disassembled
                time_count = time_count +1;
            states{1}(time_count)= T;
            states{time_count+2} = sum(VSout==11);
            end
            end
        end
        

     else %If all R-vesicles have fused
        %T   = tspan(2);
        VSout = VSin;
        rxn_count = rxn_count + 1;
    end
end


%toc
